#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Coffee beans illusionMod01.fsh   by   zduny
//https://www.shadertoy.com/view/......
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float pi = 3.1416;

const vec3 green = vec3(0.6, 0.8, 0.105);
const vec3 brown = vec3(0.627, 0.313, 0.113);
const vec3 black = vec3(0.286, 0.086, 0.027);
const vec3 white = vec3(0.976, 0.968, 0.937);

float grid = 47.0;

const bool animate = false;

vec3 toSRGB(in vec3 color) { return pow(color, vec3(1.0 / 2.2)); }

vec3 toLinear(in vec3 color) { return pow(color, vec3(2.2)); }

void drawDisk(in vec2 fragmentCoordinates, in vec2 center, in float radius,
              in vec4 color, inout vec4 outputColor) {
  float d = distance(fragmentCoordinates, center);
  float a = 1.0 - clamp(d - radius + 0.5, 0.0, 1.0);

  outputColor = mix(outputColor, color, a * color.a);
}

float sdSegment(in vec2 point, in vec2 a, in vec2 b) {
  vec2 pa = point - a;
  vec2 ba = b - a;

  float h = clamp(dot(pa, ba) / dot(ba, ba), 0.0, 1.0);

  return length(pa - ba * h);
}

void drawSegment(in vec2 fragmentCoordinates, in vec2 p0, in vec2 p1,
                 in float thickness, in vec4 color, inout vec4 outputColor) {
  float d = sdSegment(fragmentCoordinates, p0, p1);
  float a = 1.0 - clamp(d - thickness / 2.0 + 0.5, 0.0, 1.0);

  outputColor = mix(outputColor, color, a * color.a);
}

vec2 rotate(in vec2 vector, in float angle) {
  return vector * mat2(cos(angle), -sin(angle), sin(angle), cos(angle));
}

void drawBlob(in vec2 position, float angle, inout vec4 outputColor) {
  position = rotate(position, angle);
  float radius = 25.0;
  vec3 color = position.y > 0.0 ? white : black;
  drawDisk(vec2(position.x, position.y * 1.63), vec2(0.0, 0.0), radius, vec4(toLinear(color),  1.0), outputColor);
  drawDisk(vec2(position.x, position.y * 1.9), vec2(0.0, 0.0), radius * 0.87, vec4(toLinear(brown),  1.0), outputColor);
  drawSegment(position, vec2(-radius, -0.5), vec2(radius, -0.5), 0.7, vec4(toLinear(black), 1.0), outputColor);
}

float angle(int x, int y) {
  return pi / 4.0 + float(x - y) * (animate ? (0.4 + iTime * 0.01) : 0.4);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    fragColor = vec4(toLinear(green), 1.0);
    fragCoord.y = iResolution.y - fragCoord.y;
    ivec2 iFragCoord = ivec2(abs(fragCoord / grid));
    fragCoord = mod(fragCoord, grid) - 0.5 * grid;
    fragCoord += vec2(15.0, -15.0);
    drawBlob(fragCoord, angle(iFragCoord.x, iFragCoord.y), fragColor);
    drawBlob(vec2(fragCoord.x - grid, fragCoord.y), angle(iFragCoord.x + 1, iFragCoord.y), fragColor);
    drawBlob(vec2(fragCoord.x, fragCoord.y + grid), angle(iFragCoord.x, iFragCoord.y - 1), fragColor);
    drawBlob(vec2(fragCoord.x - grid, fragCoord.y + grid), angle(iFragCoord.x + 1, iFragCoord.y - 1), fragColor);
    fragColor = vec4(toSRGB(fragColor.rgb), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

